#include <Hephaestos.h>

#include <SoftPWM.h>
#include <SoftPWM_timer.h>


HEPHAESTOS heph = HEPHAESTOS();
const int BAUDRATE=9600; //9600 pour 13 IO et 6 ANA ok //11400 pour 54 IO

//definition des input
const int NBR_IN=6;  //Nombre de patte en entrées
int input[NBR_IN]={14,15,16,17,18,19}; //definit les numéros de pin utilisé en entré
boolean is_pullup[NBR_IN]={false,false,false,true,true,true}; //pour pouvoir relier la pin à la masse et se passer de résistance
boolean is_analog_in[NBR_IN]={true,true,true,false,false,false}; //definit si se sont des entrés analogique

///Definition des sortie
const int NBR_OUT=12; //Nombre de patte en sorties
int output[NBR_OUT]={2,3,4,5,6,7,8,9,10,11,12,13};  //definit les numéros de pin utilisé en sortie
boolean is_PWM[NBR_OUT]={true,true,true,true,true,true,true,true,true,true,true,true}; //si la sortie est PWM

/////////////////////Definition des parametre d'input
int threshold_analog=0; //difference necessaire pour que les changement soit pris en compte 
int sensorMin = 1023;        // minimum sensor value
int sensorMax = 0;           // maximum sensor value

byte buffer_digital[NBR_IN];
byte old_buffer_digital[NBR_IN];
boolean buttonState[NBR_IN];

void setup()
{
     Serial.begin(BAUDRATE); 
   SoftPWMBegin();
heph.begin(Serial, BAUDRATE);

 for(int i=0; i<NBR_OUT; i++)
{
 pinMode(output[i], OUTPUT);  
} 
//initialisation des entrées
for(int i=0; i<NBR_IN; i++)
{
  pinMode(input[i], INPUT);
  if(is_pullup[i]&&is_analog_in[i]==false)
  {digitalWrite(input[i], HIGH);}
  else
  {digitalWrite(input[i], LOW);}
  
} 

}

void loop()
{
heph.checkSerial();
   read_input();
for(int i=0;i<NBR_OUT; i++)
 {
   if(i<heph.hephBufferSize())
 {
 SoftPWMSet(output[i],heph.getFromHephaestos(i));
 }
 }
}

void read_input()
{
  for(int i=0; i<NBR_IN; i++)
  {
        old_buffer_digital[i]=buffer_digital[i];

    if(is_analog_in[i]==false)
   {
    if(is_pullup[i])
    {buttonState[i]= !digitalRead(input[i]);}
    if(is_pullup[i]==false)
    {buttonState[i]=digitalRead(input[i]);}
    
      if(buttonState[i])
    {
      buffer_digital[i]=255;
    }
    if(buttonState[i]==false)
    {
       buffer_digital[i]=0;
    }       
  }
  if(is_analog_in[i]==true)
   {   
     buffer_digital[i] = analogRead(input[i])/4; 
   } 
  }
  
//envoie a hephaestos le buffer
heph.setToHephaestos(buffer_digital, NBR_IN);
}
